# -*- coding: utf-8 -*-
"""
Created on Mon Sep  2 15:58:43 2024

@author: cb23
"""

import numpy as np
import os 
import glob
from scipy.interpolate import interp1d
import pandas as pd
import sys

def guiding_centre(zlayer):
    sum_num = [0,0]
    sum_den = 0
    
    for i in range(1, zlayer.shape[1] - 1):
    
        for j in range(1, zlayer.shape[2] - 1):
            r = np.array([i,j])
            vector_i_j = np.array([zlayer[0, i, j], zlayer[1, i, j], zlayer[2, i, j]])
            vector_iplus1_j = np.array([zlayer[0, i + 1, j], zlayer[1, i + 1, j], zlayer[2, i + 1, j]])
            vector_i_jplus1 = np.array([zlayer[0, i, j + 1], zlayer[1, i, j + 1], zlayer[2, i, j + 1]])
        
            cross_product = np.cross(((vector_iplus1_j - vector_i_j)),((vector_i_jplus1 - vector_i_j)))
            dot_product = np.dot(vector_i_j, cross_product)
            sum_den += dot_product
            sum_num += dot_product * r

    return sum_num / sum_den

datafiles = glob.glob('m*.npy')

filenames = [] ##Need to extract the filename number for later sorting
for file in datafiles:
    filenames.append(int(file[1:-4]))

datafiles = pd.DataFrame({'Filename' : datafiles , 'Number': filenames})
datafiles = datafiles.sort_values('Number')

x_pos_0 = []
y_pos_0 = []

x_pos_2 = []
y_pos_2 = []

for i in datafiles.index:
    print(i)
    data = np.load(datafiles.iloc[i]['Filename'])
    
    zlayer_0 = data[:,0,:,:]
    c_0 = guiding_centre(zlayer_0)
    x_pos_0.append(c_0[1])
    y_pos_0.append(c_0[0])
    
    zlayer_2 = data[:,2,:,:]
    c_2 = guiding_centre(zlayer_2)
    x_pos_2.append(c_2[1])
    y_pos_2.append(c_2[0])
    
x_pos_0 = np.array(x_pos_0)*2e-9
y_pos_0 = np.array(y_pos_0)*2e-9
x_pos_2 = np.array(x_pos_2)*2e-9
y_pos_2 = np.array(y_pos_2)*2e-9

time = np.arange(0, len(x_pos_0)*1e-10, 1e-10)
# print(len(time), len(x_pos_0), len(y_pos_0), len(x_pos_2), len(y_pos_2))

processed_data = pd.DataFrame({'Time (s)': time, 'Skyrmion 0 X Position (m)':x_pos_0, 'Skyrmion 0 Y Position (m)': y_pos_0,
                               'Skyrmion 2 X Position (m)':x_pos_2, 'Skyrmion 2 Y Position (m)': y_pos_2})
processed_data.to_csv('Sk_Positions.csv', index = False)
